﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using WebApiExample.Exceptions;
using WebApiExample.Models;

namespace WebApiExample.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class PetsController : ControllerBase
    {

        Microsoft.AspNetCore.Mvc.Infrastructure.ProblemDetailsFactory _faf;

        public PetsController(Microsoft.AspNetCore.Mvc.Infrastructure.ProblemDetailsFactory faf)
        {
            _faf = faf;
        }

        // GET: api/Pets
        [HttpGet]
        public IEnumerable<Pet> Get()
        {
            return new Pet[] { new Pet { Id = 1, Name = "Hello,World!" } };
        }

        // GET: api/Pets/5
        [HttpGet("{id}", Name = "Get")]
        public ActionResult<Pet> Get(int id)
        {
            if (id <= 0)
            {
                throw new ArgumentException(nameof(id));
            }

            if (id == 10)
            {
                throw new HttpResponseException
                {
                    Status = 888,
                    Value = new Pet { Id = id, Name = "Hello,World!" }
                };
            }

            if (id == 11)
            {
                return NotFound();
            }

            return new Pet { Id = id, Name = "Hello,World!" };
        }

        // POST: api/Pets
        [HttpPost]
        public IActionResult Post([FromBody] Pet pet)
        {
            if (!ModelState.IsValid)
            {
                //return ValidationProblem(new ValidationProblemDetails(ModelState));

                return ValidationProblem(ModelState);
            }

            if (pet.Id == 12)
            {
                return Problem(detail: "this detail", statusCode: 333, title: "id is 12");
            }

            if (pet.Id == 13)
            {
                ModelState.AddModelError(nameof(pet.Id), "id is 13");

                return ValidationProblem(ModelState);
            }

            return CreatedAtAction(nameof(Get), new { pet.Id }, pet);
        }
    }
}
