﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using CustomFormatterDemo.Models;
using System.Net.Mime;

namespace CustomFormatterDemo.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    [FormatFilter]
    public class ContactsController : Controller
    {
        private readonly IContactRepository _repository;

        public ContactsController(IContactRepository repository)
        {
            _repository = repository;
        }

        public IEnumerable<Contact> Get()
        {
            return _repository.GetAll();
        }

        [HttpGet("{id}")]
        public IActionResult Get(string id)
        {
            var contact = _repository.Get(id);

            if (contact == null)
            {
                return NotFound();
            }

            return Ok(contact);
        }

        [HttpPost]
        public IActionResult Post([FromBody]Contact contact)
        {
            _repository.Add(contact);

            return CreatedAtAction("Get", new { id = contact.ID }, contact);
        }

        // PUT api/contacts/{guid}
        [HttpPut("{id}")]
        public IActionResult Put(string id, [FromBody]Contact contact)
        {
            if (id == contact.ID)
            {
                var contactToUpdate = _repository.Get(id);
                if (contactToUpdate != null)
                {
                    _repository.Update(contact);
                    return NoContent();
                }
                return NotFound();
            }
            return BadRequest();
        }

        // DELETE api/contacts/{guid}
        [HttpDelete("{id}")]
        public IActionResult Delete(string id)
        {
            var contact = _repository.Get(id);
            if (contact == null)
            {
                return NotFound();
            }

            _repository.Remove(id);

            return NoContent();
        }
    }
}
