﻿using ModelBindingSample.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.Json;
using System.Text.Json.Serialization;
using System.Threading.Tasks;

namespace ModelBindingSample.Converters
{
    public class PetConverter : JsonConverter<Pet>
    {
        public override Pet Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
        {
            Pet pet = new Pet();

            while (reader.Read())
            {
                if (reader.TokenType == JsonTokenType.PropertyName)
                {
                    string propertyName = reader.GetString();

                    switch (propertyName)
                    {
                        case "id":
                            reader.Read();
                            pet.Id = reader.GetInt32() + 1;
                            break;

                        case "name":
                            reader.Read();
                            pet.Name = reader.GetString();
                            break;
                    }
                }
            }

            return pet;
        }

        public override void Write(Utf8JsonWriter writer, Pet value, JsonSerializerOptions options)
        {
            writer.WriteStartObject();

            writer.WriteString(nameof(value.Name).ToLower(), value.Name);

            writer.WriteString("time", DateTime.Now.ToShortTimeString());

            writer.WriteEndObject();
        }
    }
}
