﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Mime;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using ModelBindingSample.Models;

namespace ModelBindingSample.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class PetsController : ControllerBase
    {
        // GET: api/Pets
        [HttpGet]
        public IEnumerable<string> Get()
        {
            return new string[] { "value1", "value2" };
        }

        // GET: api/Pets/5
        [HttpGet("{id}", Name = "Get")]
        public Pet Get(int id, Version version)
        {
            return new Pet { Id = id, Name = "Hello,World!" };
        }

        // POST: api/Pets
        [HttpPost]
        //[Consumes(MediaTypeNames.Application.Xml)]
        public async Task<IActionResult> Post([FromForm]Pet pet)
        {
            Pet newPet = new Pet();

            await TryUpdateModelAsync(newPet);

            TryValidateModel(newPet);

            return Ok();
        }

        // PUT: api/Pets/5
        [HttpPut("{id}")]
        public IActionResult Put(int id, [FromBody] string value)
        {
            return NoContent();
        }

        // DELETE: api/ApiWithActions/5
        [HttpDelete("{id}")]
        public IActionResult Delete(int id)
        {
            return NoContent();
        }
    }
}
