﻿using Grpc.Core;
using Grpc.Health.V1;
using Grpc.Net.Client;
using GrpcService;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace GrpcClient
{
    class Program
    {
        static async Task Main()
        {
            await Task.Delay(TimeSpan.FromSeconds(8));

            var channel = GrpcChannel.ForAddress("https://localhost:5001");

            var greeterClient = new Greeter.GreeterClient(channel);
            var response = await greeterClient.SayHelloAsync(new HelloRequest { Name = "World" });
            Console.WriteLine("Greeting: " + response.Message);


            var healthClient = new Health.HealthClient(channel);
            var cts = new CancellationTokenSource();
            var call = healthClient.Watch(new HealthCheckRequest { Service = "" }, cancellationToken: cts.Token);
            var watchTask = Task.Run(async () =>
            {
                try
                {
                    await foreach (var message in call.ResponseStream.ReadAllAsync())
                    {
                        Console.WriteLine($"{DateTime.Now}: Service is {message.Status}");
                    }
                }
                catch (RpcException ex) when (ex.StatusCode == StatusCode.Cancelled)
                {
                    // Handle cancellation exception.
                }
            });

            Console.ReadKey();
        }
    }
}