﻿using IdentityServer4.Models;
using System.Collections.Generic;
using System.Security.Claims;
using IdentityModel;
using IdentityServer4.Test;

namespace Ids4.Server
{
    public class Config
    {
        public static IEnumerable<IdentityResource> GetIdentityResources()
        {
            return new List<IdentityResource>
            {
                new IdentityResources.OpenId(),
                new IdentityResources.Profile(),
                new IdentityResources.Email()
            };
        }

        public static IEnumerable<ApiResource> GetApis()
        {
            return new List<ApiResource>
            {
                new ApiResource("greeter", "greeter grpc service")
            };
        }

        public static IEnumerable<Client> GetClients()
        {
            return new List<Client>
                {
                    new Client
                    {
                        ClientId = "lingdu1",
                        ClientSecrets = { new Secret("lingdu1".Sha256()) },

                        AllowedGrantTypes = GrantTypes.ClientCredentials,
                        AllowedScopes = { "greeter" },
                        Claims=new List<Claim>{new Claim(JwtClaimTypes.Role,"role1") }
                    },
                    new Client
                    {
                        ClientId = "lingdu2",
                        ClientSecrets = { new Secret("lingdu2".Sha256()) },

                        AllowedGrantTypes = GrantTypes.ClientCredentials,
                        AllowedScopes = { "greeter" },
                        Claims=new List<Claim>{
                            new Claim(JwtClaimTypes.Role,"role2"),
                            new Claim("group","mygroup") 
                        }
                    }
                };
        }
    }
}
