﻿using Google.Protobuf.WellKnownTypes;
using Grpc.Core;
using Grpc.Net.Client;
using System;
using System.Net.Http;
using System.Threading.Tasks;
using Ticket;
using static Ticket.Ticketer;

namespace TicketClient
{
    class Program
    {
        private const string address = "https://localhost:5001";

        static async Task Main(string[] args)
        {
            await Task.Delay(TimeSpan.FromSeconds(5));

            var grpcChannel = GrpcChannel.ForAddress(address);

            TicketerClient grpcClient = new TicketerClient(grpcChannel);

            Console.WriteLine("Getting available ticket count...");
            var availableResponse = await grpcClient.GetAvailableTicketsAsync(new Empty());
            Console.WriteLine($"Available ticket count:{availableResponse.Count}");

            Console.WriteLine($"Authenticating...");
            string token = await GetToken();
            Console.WriteLine($"Successfully authenticated.");

            Metadata headers = null;

            if (token != null)
            {
                headers = new Metadata();
                headers.Add("Authorization", $"Bearer {token}");
            }

            var buyTicketResponse = await grpcClient.BuyTicketsAsync(new BuyTicketsRequest { Count = 1 }, headers);

            if (buyTicketResponse.Success)
            {
                Console.WriteLine("Purchase successful.");
            }
            else
            {
                Console.WriteLine("Purchase failed. No tickets available.");
            }

            Console.ReadKey();
        }

        static async Task<string> GetToken()
        {
            HttpClient httpClient = new HttpClient();

            var request = new HttpRequestMessage
            {
                RequestUri = new Uri($"{address}/api/token"),
                Method = HttpMethod.Get,
                Version = new Version(2, 0)
            };

            request.Headers.Add("clientId", "lingdu");
            request.Headers.Add("clientSecret", "lingdu");

            var tokenResponse = await httpClient.SendAsync(request);

            tokenResponse.EnsureSuccessStatusCode();

            var token = await tokenResponse.Content.ReadAsStringAsync();

            return token;
        }
    }
}