﻿using Google.Protobuf.WellKnownTypes;
using Grpc.Core;
using Microsoft.AspNetCore.Authorization;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Ticket;

namespace TicketServer.Services
{
    public class TicketerService : Ticketer.TicketerBase
    {
        private readonly ILogger _logger;

        private int _availableTickets = 5;

        public TicketerService(ILoggerFactory loggerFactory)
        {
            _logger = loggerFactory.CreateLogger<TicketerService>();
        }

        public override Task<AvailableTicketsResponse> GetAvailableTickets(Empty request, ServerCallContext context)
        {
            return Task.FromResult(new AvailableTicketsResponse { Count = _availableTickets }); ;
        }

        [Authorize]
        public override Task<BuyTicketsResponse> BuyTickets(BuyTicketsRequest request, ServerCallContext context)
        {
            var user = context.GetHttpContext().User;

            var updatedCount = _availableTickets - request.Count;

            // Negative ticket count means there weren't enough available tickets
            if (updatedCount < 0)
            {
                _logger.LogError($"{user} failed to purchase tickets. Not enough available tickets.");

                return Task.FromResult(new BuyTicketsResponse { Success = false });
            }

            _availableTickets = updatedCount;

            _logger.LogInformation($"{user} successfully purchased tickets.");

            return Task.FromResult(new BuyTicketsResponse { Success = true });
        }
    }
}
