using Greeter;
using Grpc.Core;
using Microsoft.Extensions.Logging;
using System.Threading.Tasks;
using static Greeter.Greeter;

namespace TicketServer
{
    public class GreeterService : GreeterBase
    {
        private readonly ILogger<GreeterService> _logger;
        public GreeterService(ILogger<GreeterService> logger)
        {
            _logger = logger;
        }

        public override Task<HelloReply> SayHello(HelloRequest request, ServerCallContext context)
        {
            return Task.FromResult(new HelloReply
            {
                Message = "Hello " + request.Name
            });
        }
    }
}
