﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.IdentityModel.Tokens;
using System;
using System.Collections.Generic;
using System.IdentityModel.Tokens.Jwt;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;

namespace TicketServer.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class TokenController : ControllerBase
    {
        private readonly IConfiguration _configuration;

        public TokenController(IConfiguration configuration)
        {
            _configuration = configuration;
        }

        public string GetToken([FromHeader]string clientId, [FromHeader]string clientSecret)
        {
            if (string.IsNullOrWhiteSpace(clientId) || clientId != clientSecret)
            {
                throw new InvalidOperationException();
            }

            string key = _configuration.GetValue<string>("Authentication:SymmetricSecurityKey");

            var securityKey = new SymmetricSecurityKey(Guid.Parse(key).ToByteArray());

            var claims = new[] {
                new Claim(ClaimTypes.Name, clientId),
                new Claim(ClaimTypes.NameIdentifier,clientId) 
            };

            var credentials = new SigningCredentials(securityKey, SecurityAlgorithms.HmacSha256);
            var token = new JwtSecurityToken("TicketServer", "TicketClient", claims, expires: DateTime.Now.AddSeconds(60), signingCredentials: credentials);

            return new JwtSecurityTokenHandler().WriteToken(token);
        }


    }
}
