﻿using Greeter;
using Grpc.Core;
using Grpc.Core.Interceptors;
using Grpc.Net.Client;
using Microsoft.Extensions.DependencyInjection;
using System;
using System.Threading;
using System.Threading.Tasks;
using static Greeter.Greeter;

namespace ConsoleApp
{
    class Program
    {
        static async Task Main()
        {
            await Task.Delay(TimeSpan.FromSeconds(5));

            await CreateClient1();

            await CreateClient2();

            Console.ReadKey();
        }

        static async Task CreateClient1()
        {
            using var channel = GrpcChannel.ForAddress("https://localhost:5001");

            var intercept = channel.Intercept(new MyClientInterceptor());

            var client = new GreeterClient(intercept);

            var request = new HelloRequest { Name = "零度" };

            var reply = await client.SayHelloAsync(request);

            Console.WriteLine(reply.Message);
        }

        static async Task CreateClient2()
        {
            ServiceCollection services = new ServiceCollection();

            services.AddSingleton(new MyClientInterceptor());

            services.AddGrpcClient<GreeterClient>(o =>
            {
                o.Address = new Uri("https://localhost:5001");
            })//.AddInterceptor(()=>new MyClientInterceptor())
            .AddInterceptor<MyClientInterceptor>()
            .ConfigureChannel(o =>
            {
                o.MaxReceiveMessageSize = 2 * 1024 * 1024;
                o.MaxSendMessageSize = 5 * 1024 * 1024;
            });

            var serviceProvider = services.BuildServiceProvider();

            var instance = ActivatorUtilities.CreateInstance<MyClass>(serviceProvider);

            await instance.RunSample();
        }
    }
}