using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using Grpc.Core;
using Microsoft.Extensions.Logging;

namespace Greeter
{
    public class GreeterService : Greeter.GreeterBase
    {
        private readonly ILogger<GreeterService> _logger;

        public GreeterService(ILogger<GreeterService> logger)
        {
            _logger = logger;
        }

        public override Task<HelloReply> SayHello(HelloRequest request, ServerCallContext context)
        {
            return Task.FromResult(new HelloReply
            {
                Message = "Hello " + request.Name
            });
        }

        public override async Task SayHelloStream1(HelloRequest request, IServerStreamWriter<HelloReply> responseStream, ServerCallContext context)
        {
            var counter = 0;

            while (!context.CancellationToken.IsCancellationRequested)
            {
                var message = $"How are you {request.Name}? {++counter}";

                _logger.LogInformation($"Sending greeting {message}.");

                await responseStream.WriteAsync(new HelloReply { Message = message });

                // Gotta look busy
                await Task.Delay(1000);
            }
        }

        public override async Task<HelloReply> SayHelloStream2(IAsyncStreamReader<HelloRequest> requestStream, ServerCallContext context)
        {
            var counter = 0;

            await foreach (var request in requestStream.ReadAllAsync())
            {
                counter += Convert.ToInt32(request.Name.Substring(2));

                _logger.LogInformation(request.Name);
            }

            return new HelloReply { Message = $"counter={counter}" };
        }

        public override async Task SayHelloStream3(IAsyncStreamReader<HelloRequest> requestStream, IServerStreamWriter<HelloReply> responseStream, ServerCallContext context)
        {
            var counter = 0;

            var lastSendCounter = 0;

            var cts = new CancellationTokenSource();

            _ = Task.Run(async () =>
                 {
                     while (!cts.IsCancellationRequested)
                     {
                         if (counter != lastSendCounter)
                         {
                             await responseStream.WriteAsync(new HelloReply
                             {
                                 Message = $"counter={counter}"
                             });

                             lastSendCounter = counter;
                         }

                         await Task.Delay(TimeSpan.FromSeconds(1));
                     }
                 }, cts.Token);


            await foreach (var request in requestStream.ReadAllAsync())
            {
                counter += Convert.ToInt32(request.Name.Substring(2));
                _logger.LogInformation(request.Name);
            }

            cts.Cancel();
        }
    }
}
