﻿using Greeter;
using Grpc.Core;
using System;
using System.Threading;
using System.Threading.Tasks;
using static Greeter.Greeter;

namespace ConsoleApp
{
    public class MyClass
    {
        private readonly GreeterClient _client;

        public MyClass(GreeterClient client)
        {
            _client = client;
        }

        public async Task RunSample()
        {
            //await UnaryCallExample();

            //await ServerStreamingCallExample();

            //await ClientStreamingCallExample();

            await BidirectionalStreamingCallExample();
        }

        private async Task UnaryCallExample()
        {
            var reply = await _client.SayHelloAsync(new HelloRequest { Name = "零度" });
            Console.WriteLine("Greeting: " + reply.Message);
        }

        private async Task ServerStreamingCallExample()
        {
            var cts = new CancellationTokenSource();

            cts.CancelAfter(TimeSpan.FromSeconds(8));

            using var call = _client.SayHelloStream1(new HelloRequest { Name = "零度" }, cancellationToken: cts.Token);

            try
            {
                await foreach (var message in call.ResponseStream.ReadAllAsync())
                {
                    Console.WriteLine("Greeting: " + message.Message);
                }
            }
            catch (RpcException ex) when (ex.StatusCode == StatusCode.Cancelled)
            {
                Console.WriteLine("Stream cancelled.");
            }
        }

        private async Task ClientStreamingCallExample()
        {
            Random random = new Random();

            using var call = _client.SayHelloStream2();

            for (var i = 0; i < 6; i++)
            {
                await call.RequestStream.WriteAsync(new HelloRequest { Name = $"零度{random.Next(1, 10)}" });

                await Task.Delay(TimeSpan.FromSeconds(2));
            }

            await call.RequestStream.CompleteAsync();

            var response = await call;

            Console.WriteLine($"Count: {response.Message}");
        }

        private async Task BidirectionalStreamingCallExample()
        {
            using var call = _client.SayHelloStream3();

            _ = Task.Run(async () =>
            {
                await foreach (var message in call.ResponseStream.ReadAllAsync())
                {
                    Console.WriteLine(message.Message);
                }
            });

            Random random = new Random();

            while (true)
            {
                await call.RequestStream.WriteAsync(new HelloRequest { Name = $"零度{random.Next(1, 10)}" });
                await Task.Delay(TimeSpan.FromSeconds(2));
            }
        }
    }
}