﻿using Greeter;
using Grpc.Net.Client;
using Microsoft.Extensions.Logging;
using System;
using System.Threading.Tasks;
using static Greeter.Greeter;

namespace ConsoleApp
{
    class Program
    {
        static async Task Main(string[] args)
        {

            var loggerFactory = LoggerFactory.Create(logging =>
            {
                logging.AddConsole();
                logging.SetMinimumLevel(LogLevel.Debug);
            });

            loggerFactory.CreateLogger("myLogger").LogInformation(Guid.NewGuid().ToString());

            using var channel = GrpcChannel.ForAddress("https://localhost:5001", new GrpcChannelOptions
            {
                LoggerFactory = loggerFactory,
                MaxReceiveMessageSize = 5 * 1024 * 1024, // 5 MB
                MaxSendMessageSize = 2 * 1024 * 1024 // 2 MB
            }); 

            var client = new GreeterClient(channel);

            var request = new HelloRequest { Name = "www.xcode.me" };

            var reply = await client.SayHelloAsync(request);

            Console.WriteLine(reply.Message);

            Console.ReadKey();

            Console.WriteLine("Hello World!");
        }
    }
}
