﻿using Microsoft.Extensions.Primitives;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace ChangeTokenExample
{
    public class ObjectChangeToken : IChangeToken
    {
        public bool HasChanged => false;

        public bool ActiveChangeCallbacks => true;

        public IDisposable RegisterChangeCallback(Action<object> callback, object state)
        {
            throw new NotImplementedException();
        }
    }

    public class MyBook
    {
        CancellationTokenSource tokenSource = new CancellationTokenSource();

        private string bookName;

        public string BookName
        {
            get { return bookName; }
            set
            {
                if (bookName != value)
                {
                    bookName = value;
                    tokenSource.Cancel();
                }
            }
        }

        public IChangeToken Watch()
        {
            return new CancellationChangeToken(tokenSource.Token);
        }
    }
}
