﻿using Microsoft.Extensions.Caching.Memory;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.FileProviders;
using Microsoft.Extensions.Options;
using Microsoft.Extensions.Primitives;
using System;
using System.Collections.Generic;
using System.IO;
using System.Threading.Tasks;

namespace ChangeTokenExample
{
    class Program
    {
        public async static Task Main(string[] args)
        {
            //await ConfigurationBuilderExample();

            //await FileProvidersExample();

            //await MemoryCacheTokenExample();

            await ObjectChangeExample();

            Console.WriteLine("Hello World!");

            await Task.CompletedTask;
        }

        public async static Task ConfigurationBuilderExample()
        {
            string path = Path.Combine(Directory.GetCurrentDirectory(), "myconfig.json");

            ConfigurationBuilder builder = new ConfigurationBuilder();

            builder.AddJsonFile(path, true, true);

            IConfiguration configuration = builder.Build();

            IChangeToken changeToken = configuration.GetReloadToken();

            changeToken.RegisterChangeCallback(o =>
            {
                Console.WriteLine("The configuration file has changed 1.");
            }, null);

            //ChangeToken.OnChange(() => configuration.GetReloadToken(), () =>
            //{
            //    Console.WriteLine("The configuration file has changed 2.");
            //});

            while (true)
            {
                string site = configuration.GetValue<string>("site");

                Console.WriteLine($"{DateTime.Now} {site}");

                await Task.Delay(TimeSpan.FromSeconds(1));
            }
        }

        public async static Task FileProvidersExample()
        {
            string root = Path.Combine(Directory.GetCurrentDirectory());

            IFileProvider fileProvider = new PhysicalFileProvider(root);

            IChangeToken changeToken = fileProvider.Watch("**/*.txt");

            changeToken.RegisterChangeCallback(o =>
            {
                Console.WriteLine("The configuration file has changed.");

                var fileProivder = o as IFileProvider;

                var fileInfo = fileProvider.GetFileInfo("TextFile.txt");

                StreamReader reader = new StreamReader(fileInfo.CreateReadStream());
                string text = reader.ReadToEnd();

                Console.WriteLine($"{DateTime.Now} {text}");

            }, fileProvider);

            await Task.Delay(TimeSpan.FromDays(1));
        }

        public async static Task MemoryCacheTokenExample()
        {
            MemoryCache cache = new MemoryCache(Options.Create(new MemoryCacheOptions()));

            while (true)
            {
                string result = cache.GetOrCreate("mytextfile", cacheEntry =>
                {
                    Console.WriteLine("Content from the hard disk storage.");

                    string root = Path.Combine(Directory.GetCurrentDirectory());
                    IFileProvider fileProvider = new PhysicalFileProvider(root);

                    IChangeToken changeToken = fileProvider.Watch("**/*.txt");

                    var fileInfo = fileProvider.GetFileInfo("TextFile.txt");

                    cacheEntry.SetSlidingExpiration(TimeSpan.FromMinutes(5)).AddExpirationToken(changeToken);

                    using var streamReader = new StreamReader(fileInfo.CreateReadStream());

                    return streamReader.ReadToEnd();
                });

                Console.WriteLine($"{DateTime.Now} {result}");

                await Task.Delay(TimeSpan.FromSeconds(5));
            }
        }

        public async static Task CompositeChangeTokenExample()
        {
            var changeTokens = new List<IChangeToken>();

            var compositeToken = new CompositeChangeToken(changeTokens);

            var dispose = compositeToken.RegisterChangeCallback(o => { }, null);

            dispose.Dispose();

            await Task.CompletedTask;
        }

        public async static Task ObjectChangeExample()
        {
            MyBook book = new MyBook();

            IChangeToken changeToken = book.Watch();

            changeToken.RegisterChangeCallback(o =>
            {
                var bookObject = o as MyBook;
                Console.WriteLine($"The object changed {bookObject.BookName}.");
            }, book);

            await Task.Delay(TimeSpan.FromSeconds(10));

            book.BookName = "C#";

            await Task.Delay(TimeSpan.FromDays(1));
        }
    }
}