﻿using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Options;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace CustomDateMiddleware
{
    public class WriteDateMiddleware
    {
        private readonly RequestDelegate next;

        private readonly DateOptions options;

        public WriteDateMiddleware(RequestDelegate next, IOptions<DateOptions> options)
        {
            this.next = next;
            this.options = options.Value;
        }

        public Task InvokeAsync(HttpContext context)
        {
            context.Response.WriteAsync(DateTime.Now.ToString(options.Format));
            return next(context);
        }
    }
}
