﻿using Microsoft.Extensions.Diagnostics.HealthChecks;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace HealthCheckSample.Extensions
{
    public class EmailHealthCheckPublisher : IHealthCheckPublisher
    {
        private readonly ILogger _logger;

        public EmailHealthCheckPublisher(ILogger<EmailHealthCheckPublisher> logger)
        {
            _logger = logger;
        }

        public Task PublishAsync(HealthReport report, CancellationToken cancellationToken)
        {
            _logger.LogInformation($"HealthReport Status { report.Status}");

            //通知第三方业务平台(电子邮件)

            return Task.CompletedTask;
        }
    }
}
