﻿using Microsoft.Extensions.Diagnostics.HealthChecks;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace HealthCheckSample.Extensions
{
    public class StartupHostedServiceHealthCheck : IHealthCheck
    {
        private volatile bool _isEvenNumber = false;

        public bool IsEvenNumber
        {
            get => _isEvenNumber;
            set => _isEvenNumber = value;
        }

        public Task<HealthCheckResult> CheckHealthAsync(HealthCheckContext context, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (IsEvenNumber)
            {
                return Task.FromResult(HealthCheckResult.Healthy("This is EvenNumber."));
            }

            return Task.FromResult(HealthCheckResult.Unhealthy("This not is EvenNumber."));
        }
    }
}
