﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using HealthCheckSample.Models;

namespace HealthCheckSample.Controllers
{
    public class HomeController : Controller
    {
        private readonly BloggingContext _bloggingContext;

        public HomeController(BloggingContext bloggingContext)
        {
            _bloggingContext = bloggingContext;
        }

        public IActionResult CreateDataBase()
        {
            if (_bloggingContext.Database.EnsureCreated())
            {
                return Content("OK");
            }
            else
            {
                return Content("Error");
            }
        }

        public IActionResult DeleteDataBase()
        {
            if (_bloggingContext.Database.EnsureDeleted())
            {
                return Content("OK");
            }
            else
            {
                return Content("Error");
            }
        }

        public IActionResult Index()
        {
            return View();
        }

        public IActionResult Privacy()
        {
            return View();
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
