﻿using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Diagnostics.HealthChecks;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace HealthCheckSample.Extensions
{
    public class ExampleHealthCheck : IHealthCheck
    {
        private readonly IHostingEnvironment _hostingEnvironment;

        public ExampleHealthCheck(IHostingEnvironment hostingEnvironment)
        {
            _hostingEnvironment = hostingEnvironment;
        }

        public Task<HealthCheckResult> CheckHealthAsync(HealthCheckContext context, CancellationToken cancellationToken = default(CancellationToken))
        {
            var healthCheckResultHealthy = File.Exists(Path.Combine(_hostingEnvironment.ContentRootPath, "abc.txt"));

            if (healthCheckResultHealthy)
            {
              return  Task.FromResult(HealthCheckResult.Healthy("The check indicates a healthy result."));
            }
            else
            {
                return Task.FromResult(HealthCheckResult.Unhealthy("The check indicates an unhealthy result."));
            }
        }
    }
}
