﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using AspNetCoreXsrfSample.Models;
using Microsoft.AspNetCore.Antiforgery;

namespace AspNetCoreXsrfSample.Controllers
{
    public class BookController : Controller
    {
        private readonly IAntiforgery _antiforgery;

        public BookController(IAntiforgery antiforgery)
        {
            _antiforgery = antiforgery;
        }

        [HttpGet]
        public IActionResult Create()
        {
            var tokens = _antiforgery.GetAndStoreTokens(HttpContext);

            HttpContext.Response.Cookies.Append("XSRF-TOKEN", tokens.RequestToken);

            return View(new BookViewModel());
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        [AutoValidateAntiforgeryToken]
        [IgnoreAntiforgeryToken]
        public IActionResult Create(BookViewModel book)
        {
            return View(new BookViewModel());
        }
    }
}
