﻿using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Threading.Tasks;

namespace AspNetCoreClinetIpSample
{
    public class SafeIPListMiddleware
    {
        private readonly RequestDelegate _next;

        private readonly ILogger<SafeIPListMiddleware> _logger;

        private readonly string _enablieSafeIPList;

        public SafeIPListMiddleware(RequestDelegate next, ILogger<SafeIPListMiddleware> logger, string enablieSafeIPList)
        {
            _next = next;
            _logger = logger;
            _enablieSafeIPList = enablieSafeIPList;
        }

        public async Task Invoke(HttpContext context)
        {
            var remoteIp = context.Connection.RemoteIpAddress;

            _logger.LogDebug($"Request from Remote IP address: {remoteIp}");

            string[] ips = _enablieSafeIPList.Split(";");

            var bytes = remoteIp.GetAddressBytes();

            var badIp = true;

            foreach (var ip in ips)
            {
                var testIp = IPAddress.Parse(ip);

                if (testIp.GetAddressBytes().SequenceEqual(bytes))
                {
                    badIp = false;
                    break;
                }
            }

            if (badIp)
            {
                _logger.LogInformation($"Forbidden Request from Remote IP address: {remoteIp}");
                context.Response.StatusCode = (int)HttpStatusCode.Forbidden;
                return;
            }

            await _next.Invoke(context);

        }
    }
}
