﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Threading.Tasks;

namespace AspNetCoreClinetIpSample
{
    public class ClientIdCheckPageFilter: IPageFilter
    {
        private readonly ILogger _logger;
        private readonly string _safelist;

        public ClientIdCheckPageFilter(ILoggerFactory loggerFactory, IConfiguration configuration)
        {
            _logger = loggerFactory.CreateLogger("ClientIdCheckPageFilter");
            _safelist = configuration["EnableSafeIPList"];
        }

        public void OnPageHandlerExecuting(PageHandlerExecutingContext context)
        {
            var remoteIp = context.HttpContext.Connection.RemoteIpAddress;

            _logger.LogDebug($"Request from Remote IP address: {remoteIp}");

            string[] ips = _safelist.Split(";");

            var bytes = remoteIp.GetAddressBytes();

            var badIp = true;

            foreach (var ip in ips)
            {
                var testIp = IPAddress.Parse(ip);

                if (testIp.GetAddressBytes().SequenceEqual(bytes))
                {
                    badIp = false;
                    break;
                }
            }

            if (badIp)
            {
                _logger.LogInformation($"Forbidden Request from Remote IP address: {remoteIp}");
                context.Result = new StatusCodeResult((int)HttpStatusCode.Forbidden);
                return;
            }
        }

        public void OnPageHandlerExecuted(PageHandlerExecutedContext context)
        {
          
        }

        public void OnPageHandlerSelected(PageHandlerSelectedContext context)
        {
           
        }
    }
}
