﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using AspNetCoreHttpsSample.Models;
using Microsoft.Extensions.Options;

namespace AspNetCoreHttpsSample.Controllers
{
    public class HomeController : Controller
    {
        private readonly MvcOptions options = null;

        public HomeController(IOptions<MvcOptions> optionAccessor)
        {
            options = optionAccessor.Value;
        }

        public IActionResult Index()
        {
            return View();
        }

        [RequireHttps]
        public IActionResult Privacy()
        {
            return View();
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View(new ErrorViewModel { RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier });
        }
    }
}
