﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using ResourceAuthorizeSample.Extensions;
using ResourceAuthorizeSample.Models;

namespace ResourceAuthorizeSample.Controllers
{
    public class ProductController : Controller
    {

        private readonly IAuthorizationService _authorizationService;

        public ProductController(IAuthorizationService authorizationService)
        {
            _authorizationService = authorizationService;
        }

        public IActionResult Create(Product product)
        {
            return View();
        }
        
        public IActionResult Read(int productId)
        {
            Product product = new Product() { ID = productId }; //来自数据库查询

            var authorizationResult = _authorizationService.AuthorizeAsync(User, product, Operations.Read.Name);

            if (authorizationResult.Result.Succeeded)
            {
                return View(product);
            }
            else if (User.Identity.IsAuthenticated)
            {
                return new ForbidResult();
            }
            else
            {
                return new ChallengeResult();
            }
        }

        public IActionResult Update(Product product)
        {
            return View();
        }

        public IActionResult Delete(int productId)
        {
            return View();
        }
    }
}