﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace IdentitySample.Mvc.Authorization
{
    public static class RoleToPermissionMap
    {
        static List<Tuple<string, string>> roleToPermissionMap = new List<Tuple<string, string>>();

        static RoleToPermissionMap()
        {
            roleToPermissionMap.Add(new Tuple<string, string>("role1", Permissions.ProductRead));
            roleToPermissionMap.Add(new Tuple<string, string>("role1", Permissions.ProductCreate));
            roleToPermissionMap.Add(new Tuple<string, string>("role1", Permissions.ProductUpdate));

            roleToPermissionMap.Add(new Tuple<string, string>("role2", Permissions.ProductRead));
            roleToPermissionMap.Add(new Tuple<string, string>("role2", Permissions.ProductCreate));
        }

        public static bool CheckPermission(string roleName, string permissionName) => roleToPermissionMap.Any(map => map.Item1 == roleName && map.Item2 == permissionName);
    }
}
