﻿using Microsoft.AspNetCore.Authorization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;

namespace IdentitySample.Mvc.Authorization
{
    public class PermissionAuthorizationHandler : AuthorizationHandler<PermissionAuthorizationRequirement>
    {
        protected override Task HandleRequirementAsync(AuthorizationHandlerContext context, PermissionAuthorizationRequirement requirement)
        {



            //一个角色有多个权限，一个用户有多个角色，然后用户分配到多个角色。
            //A人具有老师和驾驶员两个角色，老师角色能够上课，批改作业，驾驶员角色能够开车能够停车。
            //admin, user.....
            if (context.User.IsInRole("admin"))
            {
                context.Succeed(requirement);
            }
            else
            {
                var userRoles = context.User.FindAll(c => c.Type == ClaimTypes.Role).Select(c => c.Value);

                if (userRoles.Any(r => RoleToPermissionMap.CheckPermission(r, requirement.Name)))
                {
                    context.Succeed(requirement);
                }
            }

            return Task.CompletedTask;
        }
    }
}
