﻿using ClaimsSample.Models;
using Microsoft.AspNetCore.Authentication;//认证
using Microsoft.AspNetCore.Authorization; //授权
using Microsoft.AspNetCore.Authentication.Cookies;
using Microsoft.AspNetCore.Mvc;
using System.Security.Claims;
using System.Threading.Tasks;
using System;
using ClaimsSample.Extensions;

namespace ClaimsSample.Controllers
{
    public class HomeController : Controller
    {
        public IActionResult Index()
        {
            return View();
        }

        //[Authorize(Roles = "管理组"), Authorize(Roles = "演示组")]
        //[Authorize(Policy = "RequireAdminAndDemoRole")]
        //[Authorize(Policy = "RequireEmailClaim")]
        //[Authorize(Policy = "AgeMin22",AuthenticationSchemes ="Cookies,JwtBearer")]
        [MinimumAgeAuthorize(22)]
        public IActionResult Manager()
        {
            return View();
        }

        [HttpGet]
        [AllowAnonymous]
        public IActionResult Login()
        {
            return View();
        }

        [HttpPost]
        public async Task<IActionResult> Login(LoginModel model)
        {
            ClaimsPrincipal principal = null;

            if (model.UserName == "admin" && model.Password == "admin")
            {
                Claim name = new Claim(ClaimTypes.Name, model.UserName);
                Claim email = new Claim(ClaimTypes.Email, "admin@xcode.me");
                Claim role1 = new Claim(ClaimTypes.Role, "管理组");
                Claim role2 = new Claim(ClaimTypes.Role, "演示组");

                ClaimsIdentity claimsIdentity = new ClaimsIdentity("证件");
                claimsIdentity.AddClaim(name);
                claimsIdentity.AddClaim(email);
                claimsIdentity.AddClaim(role1);
                claimsIdentity.AddClaim(role2);

                principal = new ClaimsPrincipal(claimsIdentity);
            }

            if (model.UserName == "demo" && model.Password == "demo")
            {
                Claim name = new Claim(ClaimTypes.Name, model.UserName);
                Claim email = new Claim(ClaimTypes.Email, "demo@xcode.me");
                Claim role = new Claim(ClaimTypes.Role, "演示组");
                Claim birth = new Claim(ClaimTypes.DateOfBirth, DateTime.Today.AddYears(-18).ToString());

                ClaimsIdentity claimsIdentity = new ClaimsIdentity("证件");
                claimsIdentity.AddClaim(name);
                claimsIdentity.AddClaim(email);
                claimsIdentity.AddClaim(role);
                claimsIdentity.AddClaim(birth);

                principal = new ClaimsPrincipal(claimsIdentity);
            }

            if (principal == null)
            {
                ModelState.AddModelError("error", "无效的用户名或密码");
                return View(model);
            }

            await HttpContext.SignInAsync(CookieAuthenticationDefaults.AuthenticationScheme, principal);

            return RedirectToAction(nameof(Manager));
        }

        public async Task<IActionResult> SignOut()
        {
            await HttpContext.SignOutAsync(CookieAuthenticationDefaults.AuthenticationScheme);
            return RedirectToAction(nameof(Login));
        }

        public IActionResult AccessDenied()
        {
            return Content("你没权限哦！");
        }
    }
}
