﻿using ClaimsSample.Extensions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Microsoft.AspNetCore.Authorization
{
    public static class CustomAuthorizationPolicyBuilderExtensions
    {
        public static AuthorizationPolicyBuilder RequireMinimumAge(this AuthorizationPolicyBuilder builder, int minimumAge)
        {
            return builder.AddRequirements(new MinimumAgeRequirement(minimumAge));
        }
    }
}
