﻿using Microsoft.IdentityModel.Tokens;
using Microsoft.IdentityModel.Tokens.Saml;
using Microsoft.IdentityModel.Tokens.Saml2;
using Newtonsoft.Json;
using System;
using System.IO;
using System.Security.Claims;
using System.Security.Cryptography;
using System.Text;

namespace SamlTokenSample
{
    class Program
    {
        static void Main(string[] args)
        {
            string tokenString = CreateSamlToken();

            Console.WriteLine(tokenString);

            Console.WriteLine(ValidateSamlToken(tokenString));

            Console.ReadKey();
        }

        static string CreateSamlToken()
        {
            User user = new User
            {
                Id = 1,
                Name = "零度课堂",
                Email = "admin@xcode.me",
                Birthday = DateTime.Now.AddYears(-10),
                Password = "www.xcode.me",
                PhoneNumber = "18888888888"
            };

            var tokenHandler = new Saml2SecurityTokenHandler();

            string keyPrivate = File.ReadAllText(Path.Combine(Directory.GetCurrentDirectory(), "key.private.json"));

            var keyParameters = JsonConvert.DeserializeObject<RSAParameters>(keyPrivate);

            var rsaSecurityKey = new RsaSecurityKey(keyParameters);

            var tokenDescriptor = new SecurityTokenDescriptor()
            {
                Issuer = "https://www.xcode.me",
                Audience = "https://api.xcode.me",
                NotBefore = DateTime.Now,
                Expires = DateTime.UtcNow.AddMinutes(15),
                SigningCredentials = new SigningCredentials(rsaSecurityKey, SecurityAlgorithms.RsaSha256Signature, SecurityAlgorithms.Sha256Digest),
                Subject = new ClaimsIdentity(new Claim[]
                {
                    new Claim(ClaimTypes.NameIdentifier, user.Id.ToString()),
                    new Claim(ClaimTypes.Name, user.Name),
                    new Claim(ClaimTypes.Email, user.Email),
                    new Claim(ClaimTypes.MobilePhone, user.PhoneNumber),
                    new Claim(ClaimTypes.Role, "manager")
                })
            };

            var token = tokenHandler.CreateToken(tokenDescriptor);

            string tokenString = tokenHandler.WriteToken(token);

            return tokenString;
        }

        static bool ValidateSamlToken(string token)
        {
            var tokenHandler = new Saml2SecurityTokenHandler();

            string keyPrivate = File.ReadAllText(Path.Combine(Directory.GetCurrentDirectory(), "key.public.json"));
            var keyParameters = JsonConvert.DeserializeObject<RSAParameters>(keyPrivate);
            var rsaSecurityKey = new RsaSecurityKey(keyParameters);

            var tokenValidationParameters = new TokenValidationParameters
            {
                ValidIssuer = "https://www.xcode.me",
                ValidAudience = "https://api.xcode.me",
                IssuerSigningKey = rsaSecurityKey
            };

            ClaimsPrincipal retVal = null;

            try
            {
                retVal = tokenHandler.ValidateToken(token, tokenValidationParameters, out SecurityToken validatedToken);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }

            return retVal != null && retVal.Identity.IsAuthenticated;
        }
    }
}
