﻿using System;
using System.Collections.Generic;
using System.IdentityModel.Tokens.Jwt;
using System.IO;
using System.Linq;
using System.Security.Claims;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using IdentityModel;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.IdentityModel.Tokens;
using Newtonsoft.Json;

namespace IdentityProvider.Controllers
{
    public class TokenController : Controller
    {
        private readonly IHostingEnvironment _env;

        public TokenController(IHostingEnvironment env)
        {
            _env = env;
        }

        [HttpPost]
        public IActionResult GetToken([FromBody]LoginModel model)
        {
            if (model.UserName != "admin" || model.Password != "123456")
            {
                return Json(new { Error = "用户名或密码错误" });
            }

            User user = new User
            {
                Id = 1,
                Name = model.UserName,
                Email = "admin@xcode.me",
                Birthday = DateTime.Now.AddYears(-10),
                Password = model.Password,
                PhoneNumber = "18888888888"
            };

            var tokenHandler = new JwtSecurityTokenHandler();

            //var key = Encoding.ASCII.GetBytes(Consts.Secret);

            string keyPrivate = System.IO.File.ReadAllText(Path.Combine(_env.ContentRootPath, "key.private.json"));

            var keyParameters = JsonConvert.DeserializeObject<RSAParameters>(keyPrivate);

            var rsaSecurityKey = new RsaSecurityKey(keyParameters);

            var tokenDescriptor = new SecurityTokenDescriptor()
            {
                Subject = new ClaimsIdentity(new Claim[] {
                    new Claim(JwtClaimTypes.Audience,"aspnetcoreweb"),
                    new Claim(JwtClaimTypes.Issuer,"www.xcode.me"),
                    new Claim(JwtClaimTypes.Id, user.Id.ToString()),
                    new Claim(JwtClaimTypes.Name, user.Name),
                    new Claim(JwtClaimTypes.Email, user.Email),
                    new Claim(JwtClaimTypes.PhoneNumber, user.PhoneNumber),
                    new Claim(JwtClaimTypes.Role, "manager")
                }),
                Expires = DateTime.UtcNow.AddMinutes(15),
                //SigningCredentials = new SigningCredentials(new SymmetricSecurityKey(key), SecurityAlgorithms.HmacSha256Signature)
                SigningCredentials = new SigningCredentials(rsaSecurityKey, SecurityAlgorithms.RsaSha256Signature)
            };

            var token = tokenHandler.CreateToken(tokenDescriptor);

            string tokenString = tokenHandler.WriteToken(token);

            return Json(new { Token = tokenString });
        }

        public IActionResult GenerateAndSaveKey()
        {
            RSAParameters publicKeys, privateKeys;

            using (var rsa = new RSACryptoServiceProvider(2048))
            {
                try
                {
                    privateKeys = rsa.ExportParameters(true);
                    publicKeys = rsa.ExportParameters(false);
                }
                finally
                {
                    rsa.PersistKeyInCsp = false;
                }
            }

            string dir = _env.ContentRootPath;

            System.IO.File.WriteAllText(Path.Combine(dir, "key.private.json"), JsonConvert.SerializeObject(privateKeys));
            System.IO.File.WriteAllText(Path.Combine(dir, "key.public.json"), JsonConvert.SerializeObject(publicKeys));

            return Ok();
        }
    }
}