﻿using System;
using System.Net.Http;
using System.Net.Http.Headers;
using AspNetCore.Http.Extensions;
using Newtonsoft.Json.Linq;

namespace AppConsoleClient
{
    class Program
    {
        static string tokenUrl = "https://localhost:44301/Token/GetToken";

        static string apiUrl = "https://localhost:44302/HelloWorld/Test";

        static void Main(string[] args)
        {
            string tokenString = GetToken();

            string dataString = GetData(tokenString);

            Console.WriteLine(dataString);

            Console.ReadKey();
        }

        static string GetToken()
        {
            HttpClient httpClient = new HttpClient();

            var userinfo = new { UserName = "admin", Password = "123456" };

            var response = httpClient.PostAsJsonAsync(tokenUrl, userinfo).Result;

            var jsonObject = response.Content.ReadAsJsonAsync<JObject>().Result;

            return jsonObject["token"].Value<string>();
        }

        static string GetData(string token)
        {
            HttpClient httpClient = new HttpClient();

            httpClient.DefaultRequestHeaders.Authorization = new AuthenticationHeaderValue("Bearer",token);

            return httpClient.GetStringAsync(apiUrl).Result;
        }
    }
}
