﻿using IdentityModel;
using Microsoft.IdentityModel.Tokens;
using System;
using System.IdentityModel.Tokens.Jwt;
using System.Security.Claims;
using System.Text;

namespace JwtSample
{
    class Program
    {
        static void Main(string[] args)
        {
            CreateJwtToken();

            Console.ReadKey();
        }

        static void CreateJwtToken()
        {
            User user = new User
            {
                Id = 1,
                Name = "zhangsan",
                Email = "admin@xcode.me",
                Birthday = DateTime.Now.AddYears(-10),
                Password = "123",
                PhoneNumber = "18888888888"
            };

            var tokenHandler = new JwtSecurityTokenHandler();

            var key = Encoding.ASCII.GetBytes(Consts.Secret);

            var tokenDescriptor = new SecurityTokenDescriptor()
            {
                Subject = new ClaimsIdentity(new Claim[] {
                    new Claim(JwtClaimTypes.Audience,"api"),
                    new Claim(JwtClaimTypes.Issuer,"https://www.xcode.me"),
                    new Claim(JwtClaimTypes.Id, user.Id.ToString()),
                    new Claim(JwtClaimTypes.Name, user.Name),
                    new Claim(JwtClaimTypes.Email, user.Email),
                    new Claim(JwtClaimTypes.PhoneNumber, user.PhoneNumber)
                }),
                Expires = DateTime.UtcNow.AddMinutes(15),
                SigningCredentials = new SigningCredentials(new SymmetricSecurityKey(key), SecurityAlgorithms.HmacSha256Signature)
            };

            var token = tokenHandler.CreateToken(tokenDescriptor);

            string tokenString = tokenHandler.WriteToken(token);

            Console.WriteLine(tokenString);

            Console.WriteLine(ValidateJwtToken(tokenString));

            Console.ReadKey();
        }

        static bool ValidateJwtToken(string jwtTokenString)
        {
            var key = Encoding.ASCII.GetBytes(Consts.Secret);

            var tokenHandler = new JwtSecurityTokenHandler();

            var validationParameters = new TokenValidationParameters
            {
                IssuerSigningKey = new SymmetricSecurityKey(key),
                ValidAudience = "api",
                ValidIssuer= "https://www.xcode.me",
            };

            ClaimsPrincipal claimsPrincipal;
            SecurityToken validatedToken;

            try
            {
                claimsPrincipal = tokenHandler.ValidateToken(jwtTokenString, validationParameters,out validatedToken);
            }
            catch (SecurityTokenException)
            {
                return false;
            }

            return validatedToken != null;
        }
    }
}
