﻿using System;
using System.IO;
using System.Net;
using System.Net.Http;

namespace ConsoleAppClient
{
    class Program
    {
        static void Main(string[] args)
        {
            #region BaseInfo
            string apiuri = "http://demo.xcode.me";
            string userName = "administrator";
            string password = "xxxxxxxxx";
            #endregion

            #region WebRequest

            // Create a request for the URL.         
            WebRequest request = WebRequest.Create(apiuri);
            // If required by the server, set the credentials.
            request.Credentials = new NetworkCredential(userName, password);
            // Get the response.
            HttpWebResponse response = (HttpWebResponse)request.GetResponse();
            // Get the stream containing content returned by the server.
            Stream dataStream = response.GetResponseStream();
            // Open the stream using a StreamReader for easy access.
            StreamReader reader = new StreamReader(dataStream);
            // Read the content.
            string responseFromServer = reader.ReadToEnd();
            // Display the content.
            Console.WriteLine(responseFromServer);
            // Cleanup the streams and the response.
            reader.Close();
            dataStream.Close();
            response.Close();

            #endregion
                        
            #region WebClient
            WebClient webClient = new WebClient();
            webClient.Credentials = new NetworkCredential(userName, password);
            string result = webClient.DownloadString(apiuri);
            Console.WriteLine(result);


            #endregion HttpClient

            #region HttpClient

            var httpClientHandler = new HttpClientHandler()
            {
                Credentials = new NetworkCredential(userName, password)
            };

            HttpClient httpClient = new HttpClient(httpClientHandler);
            Console.WriteLine(httpClient.GetStringAsync(apiuri).Result);

            #endregion

            Console.ReadKey();
        }
    }
}
