using System;
using System.Collections.Generic;
using System.Text;

namespace ChainOfResponsibility
{
    public abstract class BaseHandler
    {
        public BaseHandler( BaseHandler next )
        {
            this.next = next;
        }

        protected abstract bool CanHandleRequest();

        public virtual void HandleRequest( Request request )
        {
            if( next != null )
            {
                this.next.HandleRequest( request );
            }
        }

        private BaseHandler next;

        public BaseHandler Next
        {
            get { return this.next; }
            set { this.next = value; }
        }
    }
}
