using System;
using System.Collections.Generic;
using System.Text;

namespace Observer
{
    public abstract class Subject
    {
        IList<IAccountObserver> observerList = new List<IAccountObserver>();

        public void AddObserver( IAccountObserver observer )
        {
            observerList.Add( observer );
        }
        public void RemoveObserver( IAccountObserver observer )
        {
            observerList.Remove( observer );
        }

        public void Notify( UserAccountArgs args )
        {
            foreach( IAccountObserver observer in observerList )
            {
                observer.Update( args );
            }
        }
    }    
}
