﻿using Microsoft.AspNetCore.Authentication;
using Microsoft.AspNetCore.Authentication.Cookies;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace ClaimsSample.Extensions
{
    public class CustomCookieAuthenticationEvents : CookieAuthenticationEvents
    {
        public async override Task ValidatePrincipal(CookieValidatePrincipalContext context)
        {
            var userPrincipal = context.Principal;
            var lastChaged = userPrincipal.Claims.Where(c=>c.Type== "LastChanged").Select(c=>c.Value).First();

            if (!string.IsNullOrEmpty(lastChaged))
            {
                //取数据库中的LastChanged字段判断用户是否修改过。

                await context.HttpContext.SignOutAsync(CookieAuthenticationDefaults.AuthenticationScheme);
            }
        }
    }
}
