﻿using ClaimsSample.Models;
using Microsoft.AspNetCore.Authentication;//认证
using Microsoft.AspNetCore.Authorization; //授权
using Microsoft.AspNetCore.Authentication.Cookies;
using Microsoft.AspNetCore.Mvc;
using System.Security.Claims;
using System.Threading.Tasks;
using System;
using Microsoft.AspNetCore.Http.Authentication.Internal;

namespace ClaimsSample.Controllers
{
    public class HomeController : Controller
    {
        public IActionResult Index()
        {
            Claim name = new Claim("姓名", "猪八戒");
            Claim name2 = new Claim(ClaimTypes.Name, "猪八戒");
            Claim email = new Claim(ClaimTypes.Email, "admin@xcode.me");
            Claim role = new Claim(ClaimTypes.Role, "C1驾驶员");

            ClaimsIdentity claimsIdentity1 = new ClaimsIdentity("身份证");
            claimsIdentity1.AddClaim(name);
            claimsIdentity1.AddClaim(email);

            ClaimsIdentity claimsIdentity2 = new ClaimsIdentity("驾驶证");
            claimsIdentity2.AddClaim(name);
            claimsIdentity2.AddClaim(email);
            claimsIdentity2.AddClaim(role);

            ClaimsPrincipal user = new ClaimsPrincipal(claimsIdentity1);
            user.AddIdentity(claimsIdentity1);
            user.AddIdentity(claimsIdentity2);

            user.IsInRole("C1驾驶员");

            var curentUser = HttpContext.User;

            curentUser = User;

            var roles = curentUser.FindAll(c => c.Type == ClaimTypes.Role);

            return View();
        }

        [Authorize(Roles = "管理组,演示组")]
        public IActionResult Manager()
        {
            return View();
        }

        [HttpGet]
        public IActionResult Login()
        {
            return View();
        }

        public async Task<IActionResult> SignOut()
        {
            await HttpContext.SignOutAsync(CookieAuthenticationDefaults.AuthenticationScheme);
            return RedirectToAction(nameof(Login));
        }

        public IActionResult AccessDenied()
        {
            return Content("你没权限哦！");
        }

        [HttpPost]
        public async Task<IActionResult> Login(LoginModel model)
        {
            ClaimsPrincipal principal = null;

            if (model.UserName == "admin" && model.Password == "admin")
            {
                Claim name = new Claim(ClaimTypes.Name, model.UserName);
                Claim email = new Claim(ClaimTypes.Email, "admin@xcode.me");
                Claim role1 = new Claim(ClaimTypes.Role, "管理组");
                Claim role2 = new Claim(ClaimTypes.Role, "演示组");
                Claim lastChanged = new Claim("LastChanged",DateTime.Now.ToString());

                ClaimsIdentity claimsIdentity = new ClaimsIdentity("证件");
                claimsIdentity.AddClaim(name);
                claimsIdentity.AddClaim(email);
                claimsIdentity.AddClaim(role1);
                claimsIdentity.AddClaim(role2);
                claimsIdentity.AddClaim(lastChanged);

                principal = new ClaimsPrincipal(claimsIdentity);
            }

            if (model.UserName == "demo" && model.Password == "demo")
            {
                Claim name = new Claim("name", model.UserName);
                Claim email = new Claim("email", "demo@xcode.me");
                Claim role = new Claim("role", "演示组");
                Claim lastChanged = new Claim("LastChanged", DateTime.Now.ToString());

                ClaimsIdentity claimsIdentity = new ClaimsIdentity("证件");
                claimsIdentity.AddClaim(name);
                claimsIdentity.AddClaim(email);
                claimsIdentity.AddClaim(role);
                claimsIdentity.AddClaim(lastChanged);

                principal = new ClaimsPrincipal(claimsIdentity);
            }

            if (principal == null)
            {
                ModelState.AddModelError("error", "无效的用户名或密码");
                return View(model);
            }

            //var ticket = new AuthenticationTicket(principal,CookieAuthenticationDefaults.AuthenticationScheme);

            //string token = JsonConvert.SerializeObject(ticket);

            ////加密

            //Response.Cookies.Append("mycookie",token);

            AuthenticationProperties properties = new AuthenticationProperties();
            properties.IsPersistent = true;

            //LastChanged

            await HttpContext.SignInAsync(CookieAuthenticationDefaults.AuthenticationScheme, principal, properties);

            return RedirectToAction(nameof(Manager));
        }
    }
}
