using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

namespace Interpreter
{
    public class WanExpression:Expression
    {
        public override int Mutiplier()
        {
            return 10000;
        }

        public override string GetPostfix()
        {
            return "";
        }
        public override void Interpret( Context context )
        {
            if( context.Statement.Length == 0 )
            {
                return;
            }
            ArrayList tree = new ArrayList();
            tree.Add( new GeExpression() );
            tree.Add( new ShiExpression() );
            tree.Add( new BaiExpression() );
            tree.Add( new QianExpression() );

            foreach( string key in table.Keys )
            {
                if( context.Statement.EndsWith( this.GetPostfix() ) )
                {
                    int temp = context.Data;
                    context.Data = 0;

                    context.Statement = context.Statement.Substring( 0, context.Statement.Length - 1 );

                    foreach( Expression exp in tree )
                    {
                        exp.Interpret( context );
                    }
                    context.Data = temp + this.Mutiplier() * context.Data;
                }
            }
        }

    }
}
