using System;
using System.Collections.Generic;
using System.Text;

namespace Interpreter
{
    public abstract class Expression
    {
        protected Dictionary<string, int> table = new Dictionary<string, int>( 9 );
        public Expression()
        {
            table.Add( "һ", 1 );
            table.Add( "", 2 );
            table.Add( "", 3 );
            table.Add( "", 4 );
            table.Add( "", 5 );
            table.Add( "", 6 );
            table.Add( "", 7 );
            table.Add( "", 8 );
            table.Add( "", 9 );
        }
        public virtual void Interpret( Context context )
        {
            if( context.Statement.Length == 0 )
            {
                return;
            }
            foreach( string key in table.Keys )
            {
                int value = table[ key ];
                if( context.Statement.EndsWith( key + GetPostfix() ) )
                {
                    context.Data += value * this.Mutiplier();
                    context.Statement = context.Statement.Substring( 0, context.Statement.Length - this.GetLenght() );
                }
                if( context.Statement.EndsWith( "" ) )
                {
                    context.Statement = context.Statement.Substring( 0, context.Statement.Length - 1 );
                }
            }
        }

        public virtual int GetLenght()
        {
            return this.GetPostfix().Length + 1;
        }

        public abstract int Mutiplier();
        public abstract string GetPostfix();
    }
}
