﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

namespace Command
{
    class Program
    {
        static void Main(string[] args)
        {
        }
    }
    class Application
    {
        Stack<ICommand> stack;
        IList<ICommand> undoList;
        IList<ICommand> redoList;

        public Application(Stack<ICommand> stack)
        {
            this.stack = stack;
        }

        public void Show()
        {
            foreach (ICommand c in stack)
            {
                c.Show();
            }
        }

        public void Redo()
        {
            ICommand command = stack.Pop();
            if (undoList.Count > 0)
            {
                command.Redo();
                redoList.Add(command);
            }
        }

        public void Undo()
        {
            if (redoList.Count > 0)
            {
                ICommand command = stack.Pop();
                command.Undo();

                undoList.Add(command);
            }
        }
    }
}
