using System;
using System.Collections.Generic;
using System.Text;

namespace Bridge
{
    public class T50 : Tank
    {
        public T50(TankPlatformImplementation tankImpl)
            : base(tankImpl)
        {
        }

        public override void Shot()
        {
            tankImpl.DoShot();
        }

        public override void Run()
        {
            tankImpl.MoveTankTo();
        }

        public override void Stop()
        {
            tankImpl.Stop();
        }
    }

    public class T75 : Tank
    {
        public T75(TankPlatformImplementation tankImpl)
            : base(tankImpl)
        {
        }

        public override void Shot()
        {
            tankImpl.DoShot();
        }

        public override void Run()
        {
            tankImpl.MoveTankTo();
        }

        public override void Stop()
        {
            tankImpl.Stop();
        }
    }

    public class T90 : Tank
    {
        public T90(TankPlatformImplementation tankImpl)
            : base(tankImpl)
        {
        }

        public override void Shot()
        {
            tankImpl.DoShot();
        }

        public override void Run()
        {
            tankImpl.MoveTankTo();
        }

        public override void Stop()
        {
            tankImpl.Stop();
        }
    }
}
