using System;
using System.Collections.Generic;
using System.Text;

namespace AbstractFactory
{
    public class GameManager
    {
        FacilitiesFactory facilitiesFactory;
        Road road;
        Building building;
        Tunnel tunnel;
        Jungle jungle;

        public GameManager( FacilitiesFactory facilitiesFactory )
        {
            this.facilitiesFactory = facilitiesFactory;
        }

        public void BuildGameFacilities()
        {
            road = facilitiesFactory.CreateRoad();
            building = facilitiesFactory.CreateBuilding();
            tunnel = facilitiesFactory.CreateTunnel();
            jungle = facilitiesFactory.CreateJungle();
        }
    }
}
