﻿using Aliyun.Acs.Core;
using Aliyun.Acs.Core.Profile;
using Aliyun.Acs.Dysmsapi.Model.V20170525;
using IdentitySample.Mvc.Services;
using Microsoft.Extensions.Options;
using SendGrid;
using SendGrid.Helpers.Mail;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Mail;
using System.Threading.Tasks;

namespace IdentitySample.Services
{
    // This class is used by the application to send Email and SMS
    // when you turn on two-factor authentication in ASP.NET Identity.
    // For more details see this link http://go.microsoft.com/fwlink/?LinkID=532713
    public class AuthMessageSender : IEmailSender, ISmsSender
    {
        private readonly SenderOptions senderOptions;

        public AuthMessageSender(IOptions<SenderOptions> optionAccessor)
        {
            senderOptions = optionAccessor.Value;
        }

        public Task SendEmailAsync(string email, string subject, string message)
        {
            SmtpClient client = new SmtpClient(senderOptions.Host);
            client.UseDefaultCredentials = false;
            client.Credentials = new NetworkCredential(senderOptions.UserName, senderOptions.Password);

            MailMessage mailMessage = new MailMessage();
            mailMessage.From = new MailAddress(senderOptions.UserName);
            mailMessage.To.Add(email);
            mailMessage.Subject = subject;
            mailMessage.Body = message;

            return client.SendMailAsync(mailMessage);
        }

        public Task SendSmsAsync(string number, string message)
        {
            string product = "Dysmsapi";
            string domain = "dysmsapi.aliyuncs.com";

            string accessKeyId = senderOptions.AliAccessKeyId;
            string secret = senderOptions.AliSecret;

            IClientProfile profile = DefaultProfile.GetProfile("cn-hangzhou", accessKeyId, secret);

            DefaultProfile.AddEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);

            IAcsClient acsClient = new DefaultAcsClient(profile);

            SendSmsRequest request = new SendSmsRequest();

            request.PhoneNumbers = number;
            request.SignName = senderOptions.SmsSignName;
            request.TemplateCode = senderOptions.SmsTemplateID;
            request.TemplateParam = "{\"code\":\"" + message + "\"}";

            acsClient.GetAcsResponse(request);

            return Task.FromResult(0);
        }
    }
}
