﻿using System;
using System.Threading.Tasks;
using Microsoft.Owin;
using Owin;
using Microsoft.Owin.Security.Cookies;
using Microsoft.Owin.Security.OpenIdConnect;
using System.Security.Claims;
using Thinktecture.IdentityModel.Client;
using System.Linq;
using Microsoft.Owin.Security;
using Microsoft.IdentityModel.Protocols;
using OauthSample.Web;

[assembly: OwinStartup(typeof(OuathSample.Web.Startup))]

namespace OuathSample.Web
{
    public class Startup
    {
        public void Configuration(IAppBuilder app)
        {
            app.UseResourceAuthorization(new AuthorizationManager());

            app.UseCookieAuthentication(new CookieAuthenticationOptions
            {
                AuthenticationType = "Cookies"
            });

            app.UseOpenIdConnectAuthentication(new OpenIdConnectAuthenticationOptions
            {
                Authority = "http://localhost:5000",
                ClientId = "zerodo3",
                RedirectUri = "http://localhost:7000/",
                ResponseType = "id_token token",
                SignInAsAuthenticationType = "Cookies",
                Scope = "openid profile roles webapi1",
                UseTokenLifetime=false,

                Notifications = new OpenIdConnectAuthenticationNotifications()
                {
                    SecurityTokenValidated = async n =>
                    {

                        var cookieUser = new ClaimsIdentity(n.AuthenticationTicket.Identity.AuthenticationType, "role", "role");

                        var userInfoUri = new Uri(n.Options.Authority + "/connect/userinfo");
                        var userInfoClient = new UserInfoClient(userInfoUri, n.ProtocolMessage.AccessToken);

                        var userInfo = await userInfoClient.GetAsync();

                        userInfo.Claims.ToList().ForEach(ui => cookieUser.AddClaim(new Claim(ui.Item1, ui.Item2)));

                        cookieUser.AddClaim(new Claim("id_token", n.ProtocolMessage.IdToken));
                        cookieUser.AddClaim(new Claim("access_token", n.ProtocolMessage.AccessToken));

                        n.AuthenticationTicket = new AuthenticationTicket(cookieUser, n.AuthenticationTicket.Properties);
                    },

                    RedirectToIdentityProvider = n => {

                        if (n.ProtocolMessage.RequestType== OpenIdConnectRequestType.LogoutRequest)
                        {
                            var idTokenHint = n.OwinContext.Authentication.User.FindFirst("id_token");

                            if (idTokenHint!=null)
                            {
                                n.ProtocolMessage.IdTokenHint = idTokenHint.Value;
                            }
                        }

                        return Task.FromResult(0);
                    }
                }
            });
        }
    }
}
