﻿using Owin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using IdentityServer3;
using IdentityServer3.Core.Configuration;
using IdentityServer3.Core.Services.InMemory;
using System.Security.Cryptography.X509Certificates;

namespace OauthSample.AuthServer
{
    public class Startup
    {
        public void Configuration(IAppBuilder appBuilder)
        {
            var options = new IdentityServerOptions {

                Factory = new IdentityServerServiceFactory()
                .UseInMemoryClients(ClientProvider.GetAllClient())
                .UseInMemoryScopes(ScopeProvider.GetAllScopes())
                .UseInMemoryUsers(UserProvider.GetAllUsers()),

                RequireSsl = false,

                AuthenticationOptions = new AuthenticationOptions {
                    EnablePostSignOutAutoRedirect = true
                },

                SigningCertificate = new X509Certificate2(string.Format(@"{0}\Certificate\idsrv3test.pfx",AppDomain.CurrentDomain.BaseDirectory), "idsrv3test")
            };

            appBuilder.UseIdentityServer(options);
        }
    }
}
