﻿using IdentityServer3.Core.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Claims;
using System.Text;
using System.Threading.Tasks;

namespace OauthSample.AuthServer
{
    public class ClientProvider
    {
        public static IEnumerable<Client> GetAllClient()
        {
            return new List<Client> {

                new Client{
                    ClientName="零度A公司",
                    ClientId="zerodo1",
                    Flow= Flows.ClientCredentials,
                    AccessTokenType= AccessTokenType.Reference,
                    ClientSecrets=new List<Secret>{
                        new Secret("288967dd-eef8-4d48-93dc-90aef3e1cee0".Sha256())
                    },
                    Claims=new List<Claim>
                    {
                        new Claim("role","role1")
                    },

                    AllowedScopes=new List<string>{"webapi1"}
                },

                new Client{
                    ClientName="零度B公司",
                    ClientId="zerodo2",
                    Flow= Flows.ClientCredentials,
                    AccessTokenType= AccessTokenType.Reference,
                    ClientSecrets=new List<Secret>{
                        new Secret("288967dd-eef8-4d48-93dc-90aef3e1cee1".Sha256())
                    },
                    Claims=new List<Claim>
                    {
                        new Claim("role","role2")
                    },
                    AllowedScopes=new List<string>{"webapi1"}
                },

                new Client{
                    ClientName="零度WEB",
                    ClientId="zerodo3",
                    Flow= Flows.Implicit,
                    AllowAccessToAllScopes=true,
                    RedirectUris=new List<string>{
                        "http://localhost:7000/"
                    },
                    PostLogoutRedirectUris=new List<string>{
                         "http://localhost:7000/"
                    }
                }
            };
        }
    }
}
