﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Http;
using Thinktecture.IdentityModel.WebApi;

namespace OauthSample.WebApi
{
    public class BookController:ApiController
    {
        private readonly BookStore bookStore = new BookStore();

        [ResourceAuthorize("GetAllBook","Book")]
        public IEnumerable<Book> Get()
        {
            return bookStore.GetAllBooks();
        }

        [ResourceAuthorize("GetBookByID", "Book")]
        public Book Get(int bookID)
        {
            return bookStore.GetAllBooks().SingleOrDefault(b => b.ID == bookID);
        }

        [ResourceAuthorize("CreateBook", "Book")]
        public void Post(Book book)
        {
            bookStore.CreateBook(book);
        }
    }
}
