﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Identity.EntityFrameworkCore;
using Microsoft.CodeAnalysis;
using Microsoft.EntityFrameworkCore;

namespace AuthSample.Data
{
    public class ApplicationDbContext : IdentityDbContext<ApplicationUser, IdentityRole<int>, int>
    {
        public ApplicationDbContext(DbContextOptions<ApplicationDbContext> options) : base(options)
        {

        }

        protected override void OnModelCreating(ModelBuilder builder)
        {
            base.OnModelCreating(builder);

            builder.Entity<ApplicationUser>(b =>
            {
                b.ToTable("User");
                b.Property(t => t.UserName).HasMaxLength(30);
                b.HasMany(p => p.Products);
            });

            builder.Entity<IdentityRole>(b=> {
                b.ToTable("Role");
            });

            builder.HasDefaultSchema("uc");
        }

        public DbSet<Product> Products { get; set; }
    }
}
